﻿using AZVIC.Ei8htPOS.BAL;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.Utilities;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace AZVIC.Ei8htPOS.WebUI.Admin.Settings
{
    public partial class HappyHourSettings : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
                LoadPromoDetails();
        }

        protected void gvHappyHours_RowCancelingEdit(object sender, GridViewCancelEditEventArgs e)
        {
            gvHappyHours.EditIndex = -1;
            LoadPromoDetails();

        }

        protected void gvHappyHours_RowEditing(object sender, GridViewEditEventArgs e)
        {
            gvHappyHours.EditIndex = e.NewEditIndex;
            LoadPromoDetails();
            
        }

        protected void gvHappyHours_RowDeleting(object sender, GridViewDeleteEventArgs e)
        {
            Guid PromoID = Guid.Parse(gvHappyHours.DataKeys[e.RowIndex].Value.ToString());
            btnDeletePromo.Attributes["data-PromoID"] = PromoID.ToString();
            LoadPromoDetails();
            ScriptManager.RegisterStartupScript(this, GetType(), "Ei8htPOS", "ConfirmDelete();", true);

        }

        protected void gvHappyHours_RowUpdating(object sender, GridViewUpdateEventArgs e)
        {
            Guid PromoID = Guid.Parse(gvHappyHours.DataKeys[e.RowIndex].Value.ToString());
            GridViewRow row = (GridViewRow)gvHappyHours.Rows[e.RowIndex];

            TextBox txtName = (TextBox)row.Cells[0].FindControl("txtPromoName");
            DropDownList ddlStartTime = (DropDownList)row.Cells[1].FindControl("ddlStartTime");
            DropDownList ddlEndTime = (DropDownList)row.Cells[2].FindControl("ddlEndTime");

            if (ValidatePromo(txtName, ddlStartTime,ddlEndTime))
            {
                HappyHours _HappyHour = new HappyHours();
                _HappyHour.UniqueID = PromoID;
                _HappyHour.PromoName = txtName.Text.Trim();
                _HappyHour.DisplayStartTime = ddlStartTime.SelectedValue;
                _HappyHour.StartTime = GetTime(ddlStartTime);
                _HappyHour.DisplayEndTime = ddlEndTime.SelectedValue;
                _HappyHour.EndTime = GetTime(ddlEndTime);
                _HappyHour.IsEnabled = true;
                _HappyHour.CreatedBy = WebSession.CurrentAdminUser != null && WebSession.CurrentAdminUser.UniqueID != Guid.Empty ? WebSession.CurrentAdminUser.UniqueID : Guid.Empty;
                HappyHourPromoBL.Save(_HappyHour);
                gvHappyHours.EditIndex = -1;
                LoadPromoDetails();
                ScriptManager.RegisterStartupScript(this, GetType(), "Ei8htPOS", "ShowAlert('Happy Hour Promo Updated successfully','Ei8htPOS')", true);
            }

        }

        private bool ValidatePromo(TextBox PromoName, DropDownList dlStartTime, DropDownList dlEndTime)
        {
            DateTime StartTime = GetTime(dlStartTime);
            DateTime EndTime = GetTime(dlEndTime);
            if (string.IsNullOrEmpty(PromoName.Text))
            {
                ScriptManager.RegisterStartupScript(this, GetType(), "Ei8htPOS", "ShowAlert('Please enter a valid Promotion Name','Ei8htPOS')", true);
                return false;
            }
            //if promo extends to second day and the end time is not 12 AM 
            if (StartTime > EndTime && EndTime.Hour != 0)
            {
                ScriptManager.RegisterStartupScript(this, GetType(), "Ei8htPOS", "ShowAlert('Please check the selected time. For promotions extending to day two (after 12 AM) please create an another promo from 12 AM.','Ei8htPOS')", true);
                return false;
            }
            else if (StartTime == EndTime)
            {
                ScriptManager.RegisterStartupScript(this, GetType(), "Ei8htPOS", "ShowAlert('Please check the selected Time slot. You cannot choose the same hour as start and End Time')", true);
                return false;
            }
            return true;
        }

        private DateTime GetTime(DropDownList cmbbox)
        {
            string selectedTime = (cmbbox.SelectedItem as ListItem).Value;
            bool IsMorning = selectedTime.Contains("AM");
            int Hour = IsMorning ? int.Parse(selectedTime.Replace("AM", "")) : int.Parse(selectedTime.Replace("PM", ""));
            Hour = (IsMorning && Hour == 12) ? 0 : (IsMorning ? Hour : (Hour != 12 ? Hour + 12 : 12));
            DateTime selctedDateTime = new DateTime(DateTime.Now.Year, DateTime.Now.Month, DateTime.Now.Day, Hour, 0, 0);
            return selctedDateTime;
        }

        protected void btnSavePromo_Click(object sender, EventArgs e)
        {
            if (ValidatePromo(txtPromoName, ddlStartTime,ddlEndTime))
            {
                HappyHours _HappyHour = new HappyHours();
                _HappyHour.PromoName = txtPromoName.Text.Trim();
                _HappyHour.DisplayStartTime = ddlStartTime.SelectedValue;
                _HappyHour.StartTime = GetTime(ddlStartTime);
                _HappyHour.DisplayEndTime = ddlEndTime.SelectedValue;
                _HappyHour.EndTime = GetTime(ddlEndTime);
                _HappyHour.IsEnabled = true;
                _HappyHour.CreatedBy = WebSession.CurrentAdminUser != null && WebSession.CurrentAdminUser.UniqueID != Guid.Empty ? WebSession.CurrentAdminUser.UniqueID : Guid.Empty;
                HappyHourPromoBL.Save(_HappyHour);
                LoadPromoDetails();
                ScriptManager.RegisterStartupScript(this, GetType(), "Ei8htPOS", "ShowAlert('Happy Hour Promo Updated successfully','Ei8htPOS')", true);
            }
        }
        private void LoadPromoDetails()
        {
            List<HappyHours> HappyHours = HappyHourPromoBL.GetList(Guid.Empty);
            if (HappyHours != null && HappyHours.Count > 0)
            {
                HappyHours = HappyHours.Where(a => a.IsEnabled).ToList<HappyHours>();
            }
            gvHappyHours.DataSource = HappyHours;
            gvHappyHours.DataBind();
            txtPromoName.Text = string.Empty;
            ddlStartTime.ClearSelection();
            ddlEndTime.ClearSelection();
        }


        protected void btnDeletePromo_Click(object sender, EventArgs e)
        {
            Guid PromoDelete = Guid.Parse(btnDeletePromo.Attributes["data-PromoID"].ToString());
            if (HappyHourPromoBL.Delete(PromoDelete))
            {
                LoadPromoDetails();
                ScriptManager.RegisterStartupScript(this, GetType(), "Ei8htPOS", "ShowAlert('Happy Hour Promo deleted successfully','Ei8htPOS')", true);
            }
        }

        protected void gvHappyHours_RowDataBound(object sender, GridViewRowEventArgs e)
        {
            if (e.Row.RowType == DataControlRowType.DataRow)
            {
                Guid PromoID = Guid.Parse(gvHappyHours.DataKeys[e.Row.RowIndex].Value.ToString());
                //GridViewRow row = (GridViewRow)gvHappyHours.Rows[e.Row.RowIndex];
                HappyHours _HappyHour = HappyHourPromoBL.GetItem(PromoID);
                DropDownList ddlStartTime = e.Row.FindControl("ddlStartTime") as DropDownList;
                DropDownList ddlEndTime = e.Row.FindControl("ddlEndTime") as DropDownList;
                if (_HappyHour != null && ddlStartTime != null && ddlEndTime != null)
                {
                    ddlStartTime.Items.FindByText(_HappyHour.DisplayStartTime).Selected=true;
                    ddlEndTime.Items.FindByText(_HappyHour.DisplayEndTime).Selected = true;
                }
            }
        }

    }
}